// TikTokAuthController.js
const TikTokAuthService = require('../services/tiktokAuthService');
const logger = require('../utils/logger');

class TikTokAuthController {
    async getTikTokAuthUrl(req, res) {
        try {
            // Get both the URL and code verifier
            const { url, codeVerifier } = await TikTokAuthService.getAuthUrl();

            // Store the code verifier in session
            req.session.tiktokCodeVerifier = codeVerifier;

            // Redirect to TikTok auth page
            res.redirect(url);
        } catch (error) {
            logger.error(`Error generating TikTok Auth URL: ${error}`);
            res.status(500).json({ error: 'Failed to generate TikTok Auth URL' });
        }
    }

    async handleTikTokCallback(req, res) {
        try {
            const { code } = req.query;
            console.log(req.query);
            const codeVerifier = req.session.tiktokCodeVerifier;
            console.log(req.session);

            if (!code) {
                throw new Error('Authorization code is missing.');
            }

            if (!codeVerifier) {
                throw new Error('Code verifier is missing.');
            }

            // Pass both code and verifier to the service
            const jwtToken = await TikTokAuthService.handleCallback(code, codeVerifier);

            // Clear the code verifier from session
            delete req.session.tiktokCodeVerifier;

            res.redirect(`${process.env.FRONTEND_URL}/auth/success?token=${jwtToken}`);
        } catch (error) {
            logger.error(`Error handling TikTok OAuth callback: ${error}`);
            res.redirect(
                `${process.env.FRONTEND_URL}/auth/error?message=${encodeURIComponent(error.message)}`
            );
        }
    }
}

module.exports = new TikTokAuthController();