const { DataTypes } = require('sequelize');
const sequelize = require('../config/db');

const Video = sequelize.define('video', {
    jobId: {
        type: DataTypes.STRING,
        allowNull: false,
        unique: true,
    },
    userId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: 'users',
            key: 'id',
        },
    },
    email: {
        type: DataTypes.STRING,
        allowNull: false,
    },
    videoPath: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    external: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    externalWebhook: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    generationStatus: {
        type: DataTypes.STRING,
        defaultValue: 'pending',
    },
    platform: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    isPostSuccessful: {
        type: DataTypes.BOOLEAN,
        defaultValue: false,
    },
    postToYoutube: {
        type: DataTypes.BOOLEAN,
        defaultValue: false,
        allowNull: false,
    },
    videoType: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    voiceType: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    artStyle: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    aspectRatio: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    duration: {
        type: DataTypes.INTEGER,
        allowNull: true,
    },
    prompt: {
        type: DataTypes.TEXT,
        allowNull: false,
    },
    generationId: {
        type: DataTypes.STRING, 
        allowNull: true,
    },
    audioURL: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    alignment: {
        type: DataTypes.JSON,
        allowNull: true,
    },
    images: {
        type: DataTypes.TEXT, 
        allowNull: true,
    },
    sentenceTimings: {
        type: DataTypes.TEXT,
        allowNull: true,
    },
    uploadTime: {
        type: DataTypes.DATE,
        allowNull: true,
    },
    enableCaptions: {
        type: DataTypes.BOOLEAN,
        defaultValue: false,
    },
    captionStyle: {
    type: DataTypes.TEXT, 
    allowNull: true,
    },
    currentStep: {
        type: DataTypes.STRING, 
        allowNull: true,
    }
}, {
    timestamps: true,
});

module.exports = Video;
