const nodemailer = require('nodemailer');
const logger = require('../utils/logger');
require('dotenv').config();

if (!process.env.SMTP_HOST || !process.env.EMAIL_USER2 || !process.env.EMAIL_PASS2) {
  throw new Error('Missing required environment variables for email configuration');
}

console.log("email", process.env.EMAIL_USER2);

const createTransporter = () => {
  console.log('Using EMAIL_USER2:', process.env.EMAIL_USER2); // Log the email being used
  return nodemailer.createTransport({
    host: process.env.SMTP_HOST,
    port: process.env.EMAIL_PORT,
    secure: true,
    auth: {
      user: process.env.EMAIL_USER2,
      pass: process.env.EMAIL_PASS2,
    },
    tls: {
      rejectUnauthorized: false,
    },
  });
};

const transporter = createTransporter();

const createMailOptions = (to, subject, html) => {
  return {
    from: process.env.EMAIL_USER2,
    to,
    subject,
    html,
  };
};


const sendVideoReadyEmail = async ({ to, jobId, videoPath, message }) => {
  const subject = 'Your Video is Ready!';
  const html = `
      <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;">
        <h2>Your Video Generation is Complete!</h2>
        <p>Great news! The video you requested has been generated successfully.</p>
        <p>${message}</p>
        <h3>Video Details:</h3>
        <ul>
          <li><strong>Job ID:</strong> ${jobId}</li>
        </ul>
        <p>You can access your video at: ${videoPath}</p>
        <p>Thank you for using our video generation service!</p>
      </div>
  `;
  try {
    const mailOptions = createMailOptions(to, subject, html);
    await transporter.sendMail(mailOptions);
  } catch (error) {
    logger.error('Error sending video ready email:', error);
    throw error;
  }
};

const sendVideoGenerationFailedEmail = async ({ to, jobId, errorMessage }) => {
  const subject = 'Video Generation Failed';
  const html = `
      <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;">
        <h2>Video Generation Error</h2>
        <p>We're sorry, but there was an issue generating your video.</p>
        <h3>Details:</h3>
        <ul>
          <li><strong>Job ID:</strong> ${jobId}</li>
          <li><strong>Error:</strong> ${errorMessage}</li>
        </ul>
        <p>Our team has been notified. Please try again or contact support if the issue persists.</p>
      </div>
  `;
  try {
    const mailOptions = createMailOptions(to, subject, html);
    await transporter.sendMail(mailOptions);
  } catch (error) {
    logger.error('Error sending video failed email:', error);
    throw error;
  }
};

const sendFailedVideotoAdmin = async ({ user, jobId, errorMessage }) => {
  const subject = `Video Generation Failed for ${user}`;
  const html = `
      <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;">
        <h2>Video Generation Error</h2>
        <p>Video failed for ${user}.</p>
        <h3>Details:</h3>
        <ul>
          <li><strong>Job ID:</strong> ${jobId}</li>
          <li><strong>Error:</strong> ${errorMessage}</li>
        </ul>
      </div>
  `;
  const to = process.env.EMAIL_ADMIN2;
  
  try {
    const mailOptions = createMailOptions(to, subject, html);
    await transporter.sendMail(mailOptions);
  } catch (error) {
    logger.error('Error sending video failed email:', error);
    throw error;
  }
};

const sendAuthEmail = async (to, subject, html) => {
  try {
    const mailOptions = createMailOptions(to, subject, html);
    await transporter.sendMail(mailOptions);
    console.log(`Email sent to ${to}`);
  } catch (error) {
    logger.error('Error sending auth email:', error);
    throw error;
  }
};

const sendAccountCreationEmail = async (creator, userEmail, userPassword) => {
  const subject = `Account Successfully Created`;
  const html = `
      <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;">
        <h2>New User Created</h2>
        <p>You have successfully created a new account for: ${userEmail}</p>
       <p>This is their pasword: ${userPassword}</p>
        
      </div>
  `;
  try {
    const mailOptions = createMailOptions(creator, subject, html);
    await transporter.sendMail(mailOptions);
  } catch (error) {
    logger.error('Error sending new user created email:', error);
    throw error;
  }
};

const sendAdminCreationEmail = async (userEmail) => {
  const subject = `New Admin Created`;
  const html = `
      <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;">
        <h2>New Admin Created</h2>
        <p>A new admin with email: ${userEmail} has been recently created!</p>        
      </div>
  `;
  const to = process.env.EMAIL_ADMIN2;
  try {
    const mailOptions = createMailOptions(to, subject, html);
    await transporter.sendMail(mailOptions);
  } catch (error) {
    logger.error('Error sending admin creation email:', error);
    throw error;
  }
};

const sendResellerCreationEmail = async (userEmail, verificationLink) => {
  const subject = `Verify Your Reseller Account`;
  const html = `
  <div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px; background-color: #f9f9f9; border-radius: 8px; color: #333;">
    <h2 style="color: #2c3e50;">Verify Your Email Address</h2>
    <p>To complete your registration, please click the link below to verify your email address:</p>
    <p>
      <a href="${verificationLink}">
        Verify Email
      </a>
    </p>
    If the link doesn't work, please copy and paste the following URL into your browser:
    <p>${verificationLink}</p>
    <p>If you did not sign up for this account, you can safely ignore this message.</p>
  </div>
`;

  const to = userEmail;
  try {
    const mailOptions = createMailOptions(to, subject, html);
    await transporter.sendMail(mailOptions);
  } catch (error) {
    logger.error('Error sending reseller verify email:', error);
    throw error;
  }
};

module.exports = { 
  sendAccountCreationEmail, 
  sendAdminCreationEmail, 
  sendAuthEmail, 
  sendVideoGenerationFailedEmail,
  sendVideoReadyEmail, 
  sendFailedVideotoAdmin,
  sendResellerCreationEmail
};
