const logger = require('../utils/logger');
const axios = require('axios');
const OpenAIService = require('../services/openaiService');
const ElevenLabsService = require('../services/elevenLabsService');
const LeonardoService = require('../services/leonardoService');
const ffmpegService = require('../services/ffmpegService');
const Video = require('../models/Video');
const { sendVideoReadyEmail, sendVideoGenerationFailedEmail, sendFailedVideotoAdmin } = require('../services/mailService');
const { parseElevenLabsTimestamps } = require('../utils/distributedTimestamps');
const youtubeService = require('./youtubeService');
const User = require('../models/User');

const processVideoGenerationJob = async (job) => {
    const { jobId, videoDetails } = job.data;
    const { videoType, voiceType, artStyle, aspectRatio, duration, platform, email, prompt } = videoDetails;
    const user = await User.findOne({ where: { email } });
        try {
            console.log("starting first openai imageprompt")
        const imagePrompt = await OpenAIService.refinePrompt(prompt, artStyle);
        console.log("starting first elevenlabs")
        const { audioPath, alignment } = await ElevenLabsService.generateAudio(prompt, voiceType);
        console.log("starting first leonardo")
        const generationId = await LeonardoService.generateImages(imagePrompt, artStyle, aspectRatio, duration);
        console.log("starting first timeout")
        await new Promise((resolve) => setTimeout(resolve, 50000));
        console.log("starting second leonardo") 
        const images = await LeonardoService.getGeneratedImages(generationId);
        const sentenceTimings = parseElevenLabsTimestamps(alignment);
        console.log("starting second ffmpeg")
        const videoPath = await ffmpegService.generateVideo({ imagePaths: images, audioPath, sentenceTimings });

        await Video.update({ generationStatus: 'completed', videoPath }, { where: { jobId } });
        let uploadError = false;

        // Handle uploads and emails (same as before)
        console.log("starting post tp youtube")
        if (platform === 'youtube') {
            if (user?.googleTokens) {
                try {
                    const videoId = await youtubeService.uploadVideo(
                        user.googleTokens.access_token,
                        user.googleTokens.refresh_token,
                        videoPath,
                        videoMetadata
                    );
                    await sendVideoReadyEmail({
                        to: email,
                        jobId,
                        message: `Your video is available on YouTube: https://www.youtube.com/watch?v=${videoId}`,
                        videoPath,
                        videoDetails,
                    });
                } catch (uploadError) {
                    logger.error(`YouTube upload failed for job ${jobId}: ${uploadError.message}`);
                    uploadError = true;
                }
            } else {
                logger.error(`Google tokens missing for user ${email}. Cannot upload to YouTube.`);
                uploadError = true;
            }
        }

        if (platform === 'email') {
            try {
                await sendVideoReadyEmail({
                    to: email,
                    jobId,
                    message: `Your video has been generated. Please find it attached.`,
                    videoPath,
                    videoDetails,
                });
            } catch (emailError) {
                logger.error(`Email sending failed for job ${jobId}: ${emailError.message}`);
                uploadError = true;
            }
        }

        if (uploadError) {
            await Video.update({
                isPostSuccessful: false,
            }, {
                where: { jobId },
            });
        } else {
            await Video.update({
                isPostSuccessful: true,
            }, {
                where: { jobId },
            });
        }

        logger.info(`Video generation completed for job ${jobId}`);
        const successMessage = "Video generation completed successfully"
        await sendVideoReadyEmail({ to: email, jobId, videoPath, message: successMessage, videoDetails })
        return { success: true, message: successMessage, videoPath };
    } catch (error) {
        await Video.update({ generationStatus: 'failed', isPostSuccessful: false }, { where: { jobId } });
        await sendVideoGenerationFailedEmail({ to: email, jobId: jobId, errorMessage: 'RES2732' });
        await sendFailedVideotoAdmin({ user: email, jobId, errorMessage: error.message })
        logger.error(`Video generation failed for job ${jobId}: ${error.message}`);

        return { success: false, message: 'Error in generating video', error: error.message };
    }
};

const generateVideoInBackground = async (jobId, externalEmail) => {
    const video = await Video.findOne({ where: { jobId } });
        if (!video) throw new Error('Video not found');

        const email = video.email;
    try {
        const platform = video.platform;
        const user = await User.findOne({ where: { email } });
        console.log(video.sentenceTimings);

        logger.info(`Running video creation for job: ${jobId}`);
        const videoPath = await ffmpegService.generateVideo({
            imagePaths: JSON.parse(video.images),
            audioURL: video.audioURL,
            sentenceTimings: JSON.parse(video.sentenceTimings),
            enableCaptions: video.enableCaptions,
            captionStyle: JSON.parse(video.captionStyle),
        });
        logger.info(`FFmpeg completed for job: ${jobId}`);
        const userPrompt = video.prompt;
        const currentStep = 'done';

        await Video.update({ generationStatus: 'completed', currentStep, videoPath }, { where: { jobId } });


        if (video.external && video.externalWebhook) {
            
            try {
                console.log(video.postToYoutube);
                let videoMetadata = null;
                if (video.postToYoutube) {
                 videoMetadata = await OpenAIService.generateVideoDetails(userPrompt);
                
                 console.log(video.uploadTime);
                 console.log(`videoMetadata ${JSON.stringify(videoMetadata)}`);
                }
                await axios.post(video.externalWebhook, {
                    jobId,
                    videoPath,
                    videoMetadata,
                    prompt: video.prompt,
                    email: externalEmail,
                    postToYoutube: video.postToYoutube,
                    currentStep,
                    uploadTime: video.uploadTime,
                    createdAt: video.createdAt,
                    status: 'completed'
                }, 
                 {
                    headers: {
                        'Authorization': `Bearer ${process.env.WEBHOOK_SECRET_TOKEN}`,
                        'X-API-Key': process.env.WEBHOOK_CLIENT_API_KEY
                    },
                    timeout: 0
                }
            );
                logger.info(`Webhook sent successfully for job ${jobId}`);
            } catch (webhookError) {
                await sendFailedVideotoAdmin({ user: email, jobId, errorMessage: "Webhook FAILED on video error" });
                logger.error(`Webhook failed for job ${jobId}: ${webhookError}`);
            }
        } else {
            let uploadError = false;
            if (platform === 'youtube') {
                if (user?.googleTokens) {
                    const videoMetadata = await OpenAIService.generateVideoDetails(userPrompt); 
                    try {
                        const videoId = await youtubeService.uploadVideo(
                            user.googleTokens.refresh_token,
                            videoPath,
                            videoMetadata
                        );
                        await sendVideoReadyEmail({
                            to: email,
                            jobId,
                            message: `Your video is available on YouTube: https://www.youtube.com/watch?v=${videoId}`,
                            videoPath,
                        });
                    } catch (uploadError) {
                        await sendVideoReadyEmail({
                            to: email,
                            jobId,
                            message: `Your video has been successfully generated, but there was an error posting to YouTube. Our team has been notified.`,
                            videoPath,
                        });
                        logger.error(`YouTube upload failed for job ${jobId}: ${uploadError.message}`);
                        uploadError = true;
                    }
                } else {
                    logger.error(`Google tokens missing for user ${email}. Cannot upload to YouTube.`);
                    uploadError = true;
                }
            }
    
            if (platform === 'email') {
                try {
                    await sendVideoReadyEmail({
                        to: email,
                        jobId,
                        message: `Your video has been generated. Please find it attached.`,
                        videoPath,
                    });
                } catch (emailError) {
                    logger.error(`Email sending failed for job ${jobId}: ${emailError.message}`);
                    uploadError = true;
                }
            }
            if (uploadError) {
                await Video.update({ isPostSuccessful: false }, { where: { jobId } });
            } else {
                await Video.update({ isPostSuccessful: true }, { where: { jobId } });
            }
    
        }
        
        logger.info(`Video generation completed for job ${jobId}`);
        return;
    } catch (error) {
        await Video.update({ generationStatus: 'failed', currentStep: 'done' }, { where: { jobId } });
        logger.error(`Error generating video: ${error.message}`);
        await sendVideoGenerationFailedEmail({ to: email, jobId, errorMessage: 'RES2732' });
        await sendFailedVideotoAdmin({ user: email, jobId, errorMessage: error.message });
        if (video?.external && video?.externalWebhook) {
            try {
                await axios.post(video.externalWebhook, {
                    jobId,
                    videoPath: null, 
                    videoMetadata: null,
                    prompt: video?.prompt,
                    email: externalEmail,
                    postToYoutube: video?.postToYoutube ?? false,
                    currentStep: 'done',
                    uploadTime: null,
                    createdAt: video?.createdAt,
                    status: 'failed'
                }, {
                    headers: {
                        'Authorization': `Bearer ${process.env.WEBHOOK_SECRET_TOKEN}`,
                        'X-API-Key': process.env.WEBHOOK_CLIENT_API_KEY
                    },
                    timeout: 0
                });
                logger.info(`❌ Webhook sent for failed job ${jobId}`);
            } catch (webhookError) {
                await sendFailedVideotoAdmin({ user: email, jobId, errorMessage: "Webhook FAILED on video error" });
                logger.error(`❌ Webhook FAILED on video error for job ${jobId}: ${webhookError}`);
            }
        }
    }
}

module.exports = generateVideoInBackground;
