const express = require('express');
const cors = require('cors');
const logger = require('./utils/logger');
const videoRoute = require('./routes/videoRoutes');
const authRoute = require('./routes/authRoutes');
const googleAuthRoute = require('./routes/googleAuthRoutes');
const tiktokAuthRoute = require('./routes/tiktokAuthRoutes');
const creatorAuthRoute = require('./routes/userManagementRoutes');
const sequelize = require('./config/db');
// const { sessionMiddleware } = require('./config/redisClient');
require('dotenv').config();


const app = express();
const PORT = process.env.PORT || 5000;

sequelize.authenticate()
  .then(() => logger.info('Database Connection has been established successfully.'))
  .catch(err => logger.error(`Unable to connect to the database: ${err}`));

  app.use(cors({
    origin: ['https://tubecentric.com', 'http://localhost:5173', 'http://localhost:3000', 'https://autoshort-repl.vercel.app'], // Use an array for multiple origins
    credentials: true,
    methods: ['GET', 'POST', 'PUT', 'DELETE', 'OPTIONS'],
    allowedHeaders: ['Content-Type', 'Authorization']
}));

// app.use(sessionMiddleware);

app.use(express.json());

app.get('/', (req, res) => {
  logger.info('Root endpoint accessed');
  res.send('Hello World!');
});

app.use('/api/v1', videoRoute);
app.use('/api/v1', authRoute);
app.use('/api/v1', googleAuthRoute);
app.use('/api/v1', tiktokAuthRoute);
app.use('/api/v1', creatorAuthRoute);

// Example of logging errors
app.use((err, req, res, next) => {
  logger.error(`An error occurred: ${err.message}`);
  res.status(500).send('Internal Server Error');
});

app.listen(PORT, () => {
  logger.info(`Server is running on port ${PORT}`);
});


