'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.addColumn("videos", "generationId", {
      type: Sequelize.STRING,
      allowNull: true,
    });

    await queryInterface.addColumn("videos", "audioURL", {
      type: Sequelize.STRING,
      allowNull: true,
    });

    await queryInterface.addColumn("videos", "alignment", {
      type: Sequelize.JSON,
      allowNull: true,
    });

    await queryInterface.addColumn("videos", "images", {
      type: Sequelize.JSON,
      allowNull: true,
    });

    await queryInterface.addColumn("videos", "sentenceTimings", {
      type: Sequelize.JSON,
      allowNull: true,
    });
  },

  async down(queryInterface, Sequelize) {
    await queryInterface.removeColumn("videos", "generationId");
    await queryInterface.removeColumn("videos", "audioURL");
    await queryInterface.removeColumn("videos", "alignment");
    await queryInterface.removeColumn("videos", "images");
    await queryInterface.removeColumn("videos", "sentenceTimings");
  },
};

