const express = require('express');
const router = express.Router();
const { check } = require('express-validator');
const UserManagementController = require('../controllers/userManagement');
const { authMiddleware, isAdmin, isReseller, isAdminOrReseller } = require('../middlewares/authMiddleware');



// Routes
router.post('/create-user',
    authMiddleware,
    isAdminOrReseller,
    [
        check('name', 'Full name is required').notEmpty(),
        check('email', 'Please include a valid email').isEmail(),
        check('accountType', 'Account Type is required').notEmpty(),
    ],
    UserManagementController.createUser
);

router.put('/update-user/:userId',
    authMiddleware,
    isAdminOrReseller,
    UserManagementController.updateUser
);

router.get('/fetch-user/:userId',
    authMiddleware,
    isAdminOrReseller,
    UserManagementController.getUser
);

router.get('/reseller/all/users', authMiddleware, isReseller, UserManagementController.getResellerUsers);
router.get('/reseller/bundle/users', authMiddleware, isReseller, UserManagementController.getBundleUsers);
router.get('/reseller/premium/users', authMiddleware, isReseller, UserManagementController.getPremiumUsers);

// Admin routes
router.get('/admin/all/users', authMiddleware, isAdmin, UserManagementController.getAllUsers);
router.get('/admin/bundle/users', authMiddleware, isAdmin, UserManagementController.getBundleUsers);
router.get('/admin/premium/users', authMiddleware, isAdmin, UserManagementController.getPremiumUsers);
router.get('/admin/reseller/users', authMiddleware, isAdmin, UserManagementController.getResellerAccounts);

module.exports = router;