const Queue = require('bull');
const logger = require('../utils/logger');
require('dotenv').config();

const videoQueue = new Queue('video-generation', {
    redis: {
        host: process.env.REDIS_HOST,
        port: process.env.REDIS_PORT,
        password: process.env.REDIS_PASS,
        maxRetriesPerRequest: null,
        enableReadyCheck: false,
    }
});

class JobQueue {
    async add(jobName, data) {
        logger.info(`Adding job with name: ${jobName}`);
        return videoQueue.add('video-generation', data);
    }
}

module.exports = JobQueue;
