const axios = require('axios');

class TikTokService {
    constructor() {
        this.uploadUrl = 'https://open.tiktokapis.com/v2/video/upload/';
        this.initUploadUrl = 'https://open.tiktokapis.com/v2/video/init/';
    }

    async initUpload(accessToken) {
        try {
            const response = await axios.post(
                this.initUploadUrl,
                {},
                {
                    headers: {
                        Authorization: `Bearer ${accessToken}`,
                        'Content-Type': 'application/json',
                    },
                }
            );

            const { upload_id } = response.data.data;
            return upload_id;
        } catch (error) {
            console.error('Error initializing TikTok video upload:', error);
            throw error;
        }
    }

    async uploadVideoChunk(accessToken, uploadId, videoBuffer) {
        try {
            const response = await axios.post(
                `${this.uploadUrl}${uploadId}/`,
                videoBuffer,
                {
                    headers: {
                        Authorization: `Bearer ${accessToken}`,
                        'Content-Type': 'application/octet-stream',
                    },
                }
            );

            return response.data;
        } catch (error) {
            console.error('Error uploading video chunk:', error);
            throw error;
        }
    }

    async completeUpload(accessToken, uploadId, videoTitle) {
        try {
            const response = await axios.post(
                `${this.uploadUrl}${uploadId}/complete/`,
                { video_title: videoTitle },
                {
                    headers: {
                        Authorization: `Bearer ${accessToken}`,
                        'Content-Type': 'application/json',
                    },
                }
            );

            return response.data;
        } catch (error) {
            console.error('Error completing TikTok video upload:', error);
            throw error;
        }
    }

    async uploadVideo(accessToken, videoBuffer, videoTitle) {
        try {
            // Step 1: Initialize upload
            const uploadId = await this.initUpload(accessToken);

            // Step 2: Upload video
            await this.uploadVideoChunk(accessToken, uploadId, videoBuffer);

            // Step 3: Complete upload
            const result = await this.completeUpload(accessToken, uploadId, videoTitle);

            return result;
        } catch (error) {
            console.error('Error uploading video to TikTok:', error);
            throw error;
        }
    }
}

module.exports = new TikTokService();
